<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../includes/config.php';

header('Content-Type: application/json');

// Start session and check authentication
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized - Admin session not found']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    // Use global PDO
    global $db1;

    // Return one balance per account.
    // If account has currency set, balance is for that currency only.
    // If currency is NULL, sum across all currencies (note: mixed currencies).
    $sql = "
        SELECT 
            a.id,
            a.name,
            a.type,
            a.currency,
            a.is_active,
            COALESCE(SUM(CASE 
                WHEN l.type = 'credit' THEN l.amount 
                WHEN l.type = 'debit' THEN -l.amount 
                ELSE 0 END), 0) AS balance
        FROM accounts a
        LEFT JOIN account_ledger l 
            ON l.account_id = a.id
            AND (a.currency IS NULL OR l.currency = a.currency)
        GROUP BY a.id, a.name, a.type, a.currency, a.is_active
        ORDER BY a.name ASC
    ";

    $stmt = $db1->prepare($sql);
    $stmt->execute();
    $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'data' => $accounts
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}
?>


