<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
include_once("../includes/config.php");
include_once("../functions.php");

// Get the license key and email from the request
$license = isset($_REQUEST['license']) ? trim($_REQUEST['license']) : '';
$email = isset($_REQUEST['email']) ? trim($_REQUEST['email']) : null;

// Validate license key
if (empty($license)) {
    echo json_encode([
        'success' => false,
        'message' => 'License key is required'
    ]);
    exit;
}

try {
    // If email is provided, update the license email
    if ($email !== null) {
        // Check if email is already used by another client
        if (!empty($email)) {
            $check_sql = "SELECT c.Id 
                         FROM tbl_clients c 
                         LEFT JOIN license l ON l.client_id = c.Id 
                         WHERE c.license_email = :email 
                         AND l.license_code != :license";
            $check_stmt = $db1->prepare($check_sql);
            $check_stmt->execute([
                ':email' => $email,
                ':license' => $license
            ]);
            
            if ($check_stmt->rowCount() > 0) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Email address is already in use'
                ]);
                exit;
            }
        }

        // Update the license email
        $update_sql = "UPDATE tbl_clients c 
                      INNER JOIN license l ON l.client_id = c.Id 
                      SET c.license_email = :email 
                      WHERE l.license_code = :license";
        $update_stmt = $db1->prepare($update_sql);
        $update_stmt->execute([
            ':email' => $email,
            ':license' => $license
        ]);
        
        if ($update_stmt->rowCount() === 0) {
            echo json_encode([
                'success' => false,
                'message' => 'License not found'
            ]);
            exit;
        }
    }

    // Get current license email
    $select_sql = "SELECT c.license_email 
                   FROM tbl_clients c 
                   INNER JOIN license l ON l.client_id = c.Id 
                   WHERE l.license_code = :license";
    $select_stmt = $db1->prepare($select_sql);
    $select_stmt->execute([':license' => $license]);

    if ($select_stmt->rowCount() === 0) {
        echo json_encode([
            'success' => false,
            'message' => 'License not found'
        ]);
        exit;
    }

    $row = $select_stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'message' => $email !== null ? 'License email updated successfully' : 'License email retrieved successfully',
        'license_email' => $row['license_email']
    ]);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error occurred',
        'error' => $e->getMessage()
    ]);
    exit;
}
