-- Add new columns to tbl_clients for Enjaz Feeding Center and Umrah Feeding Center
ALTER TABLE `tbl_clients` 
ADD COLUMN `enjaz_feeding_center` TINYINT(4) NOT NULL DEFAULT 0 AFTER `license_enabled`,
ADD COLUMN `umrah_feeding_center` TINYINT(4) NOT NULL DEFAULT 0 AFTER `enjaz_feeding_center`,
ADD COLUMN `enjaz_payment` TINYINT(4) NOT NULL DEFAULT 0 AFTER `umrah_feeding_center`; 

-- Create table for account managers
CREATE TABLE IF NOT EXISTS `tbl_account_managers` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(150) NOT NULL,
  `email` VARCHAR(190) DEFAULT NULL,
  `phone` VARCHAR(50) DEFAULT NULL,
  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_am_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add foreign key from clients to account managers
ALTER TABLE `tbl_clients`
  ADD COLUMN `account_manager_id` INT UNSIGNED NULL AFTER `license_email`;

ALTER TABLE `tbl_clients`
  ADD CONSTRAINT `fk_clients_account_manager`
  FOREIGN KEY (`account_manager_id`) REFERENCES `tbl_account_managers` (`id`)
  ON UPDATE CASCADE ON DELETE SET NULL;