<?php
require_once('../includes/config.php');

header('Content-Type: application/json');

if (!isset($_GET['client_id'])) {
    echo json_encode(['error' => 'Client ID is required']);
    exit;
}

$client_id = intval($_GET['client_id']);

try {
    $data = [];
    
    // Get hardware license visa count
    $query = "SELECT COUNT(*) AS counter FROM `authumra_visas`.`visa_number` 
             WHERE hardware_id IN (SELECT license_code FROM license WHERE client_id = :client_id)";
    $stmt = $db1->prepare($query);
    $stmt->execute(['client_id' => $client_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $data['printed_visa_counter'] = $row['counter'];

    // Get current year (1446) visa counts by type
    $types = ['VOU', 'VOH', 'VOE', 'VOT', 'VOW'];
    $data['current_year'] = [];
    foreach ($types as $type) {
        $query = "SELECT COUNT(*) AS counter FROM visas_1446 
                 WHERE client_id = :client_id 
                 AND type = (SELECT id FROM visa_types WHERE type = :type)";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id, 'type' => $type]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['current_year'][$type] = $row['counter'];
    }

    // Get yesterday's count
    $query = "SELECT COUNT(*) AS counter FROM visas_1446 
             WHERE client_id = :client_id 
             AND type = 1 
             AND DATE(timestamp) = DATE_SUB(DATE(NOW()), INTERVAL 1 DAY)";
    $stmt = $db1->prepare($query);
    $stmt->execute(['client_id' => $client_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $data['yesterday_count'] = $row['counter'];

    // Get passport counts for current year
    $data['passport_counts'] = [];
    foreach ($types as $type) {
        $query = "SELECT COUNT(*) AS counter FROM passports_1446_2024 
                 WHERE client_id = :client_id 
                 AND type = (SELECT id FROM visa_types WHERE type = :type)";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id, 'type' => $type]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['passport_counts'][$type] = $row['counter'];
    }

    // Get historical years data
    $years = ['1445', '1444', '1443', '1442', '1441', '1440', '1439', '1438'];
    $data['historical'] = [];
    foreach ($years as $year) {
        $data['historical'][$year] = [
            'visas' => [],
            'passports' => []
        ];
        
        // Get visa counts
        foreach ($types as $type) {
            $query = "SELECT COUNT(*) AS counter FROM visas_$year 
                     WHERE client_id = :client_id 
                     AND type = (SELECT id FROM visa_types WHERE type = :type)";
            $stmt = $db1->prepare($query);
            $stmt->execute(['client_id' => $client_id, 'type' => $type]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data['historical'][$year]['visas'][$type] = $row['counter'];
        }
        
        // Get passport counts
        foreach ($types as $type) {
            $query = "SELECT 
                COUNT(DISTINCT(ppno)) AS unique_count,
                COUNT(*) AS total_count 
                FROM passports_$year 
                WHERE client_id = :client_id 
                AND type = (SELECT id FROM visa_types WHERE type = :type)";
            $stmt = $db1->prepare($query);
            $stmt->execute(['client_id' => $client_id, 'type' => $type]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data['historical'][$year]['passports'][$type] = [
                'unique' => $row['unique_count'],
                'total' => $row['total_count']
            ];
        }
    }

    echo json_encode($data);

} catch (PDOException $e) {
    error_log("Credit Info Error: " . $e->getMessage());
    echo json_encode(['error' => 'Database error occurred']);
} 