<?php ob_start(); ?>
<?php @session_start(); ?>
<?php require_once("includes/config.php"); ?>
<?php require_once("includes/DataBaseObjects.php"); ?>
<?php require_once("functions.php"); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">    
    <style>
        :root {
            --primary-red: #dc3545;
            --dark-gray: #212529;
            --success-green: #198754;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .navbar {
            background-color: white !important;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-outline-primary {
            color: var(--dark-gray);
            border-color: var(--dark-gray);
        }
        
        .btn-outline-primary:hover {
            background-color: var(--dark-gray);
            color: white;
            border-color: var(--dark-gray);
        }

        .btn-outline-success {
            color: var(--success-green);
            border-color: var(--success-green);
        }
        
        .btn-outline-success:hover {
            background-color: var(--success-green);
            color: white;
            border-color: var(--success-green);
        }

        .btn-outline-warning {
            color: var(--dark-gray);
            border-color: var(--dark-gray);
        }
        
        .btn-outline-warning:hover {
            background-color: var(--dark-gray);
            color: white;
            border-color: var(--dark-gray);
        }

        .nav-link.active {
            color: var(--primary-red) !important;
            font-weight: bold;
        }

        .navbar-text {
            color: var(--dark-gray) !important;
        }
    </style>
    <script>
        function toggleVisibility(id) {
        var element = document.getElementById(id);
        if (element.style.display === "none") {
            element.style.display = "block"; // Show the element
        } else {
            element.style.display = "none";  // Hide the element
        }
    }
    </script>

</head>
<body>

<!-- Navigation Menu -->
<nav class="navbar navbar-expand-lg navbar-light bg-light sticky-top">
    <div class="container">
        <a class="navbar-brand" href="index.php">
            <img src="../images/logo.png" alt="Virgo Logo" height="100">
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav w-100 justify-content-evenly">
                <li class="nav-item">
                    <a class="nav-link <?php echo !isset($_GET['page']) ? 'active' : ''; ?>" href="index.php">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                </li>
                
                <!-- Clients Section -->
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'add_client' ? 'active' : ''; ?>" href="?page=add_client">
                        <i class="bi bi-person-plus"></i> Add Client
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'edit_clients' ? 'active' : ''; ?>" href="?page=edit_clients">
                        <i class="bi bi-pencil-square"></i> Edit Clients
                    </a>
                </li>
            </ul>
            
            <!-- User Info and Logout -->
            <div class="navbar-nav">
                <span class="nav-item navbar-text me-3">
                    <i class="bi bi-person"></i> 
                    <?php echo htmlspecialchars($_SESSION['admin_username']); ?> 
                    (<?php echo htmlspecialchars($_SESSION['admin_type']); ?>)
                </span>
                <a href="logout.php" class="btn btn-outline-danger">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
        </div>
    </div>
</nav>

<!-- Body Container -->
<div class="container mt-4">
    <?php include_once("content.php"); ?>
</div>

<!-- Bootstrap JS and Popper.js -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<?php
// Enable error reporting for development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Custom error handler
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    $errorType = match($errno) {
        E_ERROR => 'Fatal Error',
        E_WARNING => 'Warning',
        E_PARSE => 'Parse Error',
        E_NOTICE => 'Notice',
        E_CORE_ERROR => 'Core Error',
        E_CORE_WARNING => 'Core Warning',
        E_COMPILE_ERROR => 'Compile Error',
        E_COMPILE_WARNING => 'Compile Warning',
        E_USER_ERROR => 'User Error',
        E_USER_WARNING => 'User Warning',
        E_USER_NOTICE => 'User Notice',
        default => 'Unknown Error'
    };
    
    // Only show detailed error info if it's not a notice
    if ($errno !== E_NOTICE) {
        echo "<div class='alert alert-danger' role='alert'>
                <h4 class='alert-heading'>$errorType</h4>
                <p><strong>Message:</strong> $errstr</p>
                <hr>
                <p class='mb-0'><strong>File:</strong> $errfile</p>
                <p class='mb-0'><strong>Line:</strong> $errline</p>
              </div>";
    }
    
    // Don't execute PHP internal error handler
    return true; 
}

// Set the custom error handler
set_error_handler("customErrorHandler");

// Add exception handler
function customExceptionHandler($exception) {
    echo "<div class='alert alert-danger' role='alert'>
            <h4 class='alert-heading'>Uncaught Exception</h4>
            <p><strong>Message:</strong> " . $exception->getMessage() . "</p>
            <hr>
            <p class='mb-0'><strong>File:</strong> " . $exception->getFile() . "</p>
            <p class='mb-0'><strong>Line:</strong> " . $exception->getLine() . "</p>
          </div>";
}

// Set the custom exception handler
set_exception_handler("customExceptionHandler");

// Add this to catch database errors
function handleDatabaseError($message) {
    echo "<div class='alert alert-danger' role='alert'>
            <h4 class='alert-heading'>Database Error</h4>
            <p>$message</p>
          </div>";
}

// Add some CSS for error styling
?>
<style>
    .alert-danger {
        background-color: #fff;
        border-left: 5px solid #dc3545;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        margin: 15px 0;
        padding: 15px 20px;
    }
    .alert-danger .alert-heading {
        color: #dc3545;
        font-size: 1.1rem;
        margin-bottom: 10px;
    }
    .alert-danger hr {
        border-top-color: #f5c6cb;
        margin: 15px 0;
    }
    .alert-danger p {
        margin-bottom: 8px;
        font-size: 0.95rem;
    }
    .alert-danger strong {
        color: #721c24;
    }
</style>
<script>
    // Fix dropdown on mobile
    document.addEventListener('DOMContentLoaded', function() {
        var dropdowns = document.querySelectorAll('.dropdown-toggle');
        dropdowns.forEach(function(dropdown) {
            dropdown.addEventListener('click', function(e) {
                if (window.innerWidth < 992) {
                    e.preventDefault();
                    e.stopPropagation();
                    var dropdownMenu = this.nextElementSibling;
                    dropdownMenu.classList.toggle('show');
                }
            });
        });
    });
</script>
</body>
</html>
