<?php ob_start(); ?>
<?php @session_start(); ?>
<?php include("includes/config.php"); ?>
<?php require_once("functions.php"); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin - Login</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Bootstrap CSS -->
    <link href="../includes/bootstrap-5.0.2-dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.8.1/font/bootstrap-icons.min.css">

    <!-- Custom Style -->
    <link rel="stylesheet" href="includes/css/style.css">

    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .btn-danger { /* Change to btn-danger for red button */
            background-color: #dc3545; /* Bootstrap red color */
            border: none;
            border-radius: 25px;
            padding: 10px 20px;
        }
        .btn-danger:hover {
            background-color: #c82333; /* Darker red on hover */
        }
        .logo {
            max-width: 100px; /* Adjust the size as needed */
            margin-bottom: 20px; /* Space below the logo */
        }
    </style>
</head>
<body>

<!-- Body Container -->
<div class="container d-flex align-items-center justify-content-center vh-100">

    <!-- Card Layout for Login -->
    <div class="card p-4 col-md-5">
        <div class="text-center mb-4">
            <!-- Logo -->
            <img src="https://offline.umrah.software/images/logo.png" alt="Virgo Logo" class="logo">
            <h2>Virgo! Admin Login</h2>
        </div>
        <form action="" method="post" novalidate>
            <div class="mb-3">
                <label for="Uname" class="form-label">User Name <i class="bi bi-person-fill"></i>:</label>
                <input type="text" id="Uname" name="Uname" class="form-control" required>
                <div class="invalid-feedback">Please enter your username.</div>
            </div>
            <div class="mb-3">
                <label for="pass" class="form-label">Password <i class="bi bi-lock-fill"></i>:</label>
                <input type="password" id="pass" name="pass" class="form-control" required>
                <div class="invalid-feedback">Please enter your password.</div>
            </div>
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-danger btn-block">Login</button> <!-- Changed to btn-danger -->
            </div>
            <div class="text-center mt-3">
                <a href="#">Forget My Password</a>
            </div>
            <!-- Login Function -->
            <?php login($db1); ?>
            <!-- End Login Function -->
        </form>
    </div>

</div>

<!-- Bootstrap JS and Popper.js -->
<script src="../includes/bootstrap-5.0.2-dist/js/bootstrap.bundle.min.js"></script>

<!-- Form Validation Script -->
<script>
    (function () {
        'use strict'
        var forms = document.querySelectorAll('form')
        Array.prototype.slice.call(forms)
            .forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }
                    form.classList.add('was-validated')
                }, false)
            })
    })()
</script>

</body>
</html>
