<?php // include("../includes/config.php"); ?>
<!-- ========== AJAX Get_Clients  ===================== -->
 <script src="includes/js/Get_Clients.js?v=<?php echo time(); ?>" type="text/javascript"></script>
 <!-- Clipboard Copy Script -->
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('License Code copied to clipboard: ' + text);
    }, function() {
        alert('Failed to copy License Code.');
    });
}
</script>
<!-- Flashing Red Effect CSS -->
<style>
    .container {
        max-width: 1200px;
        padding: 2rem;
    }
    .search-section {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2rem;
    }
    .form-control {
        border-radius: 25px;
        padding: 0.75rem 1.5rem;
        border: 1px solid #e0e0e0;
        transition: all 0.3s ease;
    }
    .form-control:focus {
        box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        border-color: #dc3545;
    }
    select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%23333' viewBox='0 0 16 16'%3E%3Cpath d='M8 12l-6-6h12z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        padding-right: 2.5rem !important;
    }
    .country-section {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2rem;
    }
    #txtHint {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    .flashing-red {
        animation: flashing 1.5s ease-in-out infinite alternate;
        font-weight: 600;
    }
    @keyframes flashing {
        0% { color: #dc3545; }
        100% { color: #495057; }
    }
    .btn {
        padding: 0.75rem 1.5rem;
        border-radius: 25px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        border: none;
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
    }
    .alert {
        border-radius: 15px;
        padding: 1rem 1.5rem;
        margin-bottom: 1.5rem;
        border: none;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }
</style>

<!-- ================================================== -->	
<div class="container mt-4">
    <!-- Success Message -->
    <?php Message("Client_Deleted_Successfully", "alert alert-success", "success_icon.png", "Client Successfully Deleted "); ?>

    <!-- Search Section -->
    <div class="search-section">
        <form action="?page=search_clients" method="post" class="d-flex gap-2">
            <input type="text" name="key_word" class="form-control" placeholder="Search clients...">
            <button type="submit" class="btn btn-primary">Search</button>
        </form>
    </div>

    <!-- Country Section -->
    <div class="country-section">
        <div class="mb-3">
            <label for="Country" class="form-label fw-bold">Country:</label>
            <select name="Country" id="Country" class="form-control" onChange="ShowClients(this.value)">
                <option value=''>--- Select Country ---</option>
                <option value='all'>All</option>
                <?php Get_Countries(); ?>
            </select>
        </div>
    </div>

    <!-- Clients Result Section -->
    <div id="txtHint">
        <b>Clients info will be listed here.</b>
    </div>
</div>
    <!-- ========== DELETE CLIENT  ======================== -->
    <script src="../includes/js/Delete_Client.js" type="text/javascript"></script>
    <!-- ================================================== -->